/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.immediate.model;

import java.util.Set;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;

public class ModelCuboid {
    public static final int FACE_NEG_Y = 0;
    public static final int FACE_POS_Y = 1;
    public static final int FACE_NEG_X = 2;
    public static final int FACE_NEG_Z = 3;
    public static final int FACE_POS_X = 4;
    public static final int FACE_POS_Z = 5;
    public final float x1;
    public final float y1;
    public final float z1;
    public final float x2;
    public final float y2;
    public final float z2;
    public final float u0;
    public final float u1;
    public final float u2;
    public final float u3;
    public final float u4;
    public final float u5;
    public final float v0;
    public final float v1;
    public final float v2;
    private final int cullBitmask;
    public final boolean mirror;

    public ModelCuboid(int u, int v, float x1, float y1, float z1, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, boolean mirror, float textureWidth, float textureHeight, Set<class_2350> renderDirections) {
        float x2 = x1 + sizeX;
        float y2 = y1 + sizeY;
        float z2 = z1 + sizeZ;
        x1 -= extraX;
        y1 -= extraY;
        z1 -= extraZ;
        x2 += extraX;
        y2 += extraY;
        z2 += extraZ;
        if (mirror) {
            float tmp = x2;
            x2 = x1;
            x1 = tmp;
        }
        this.x1 = x1 / 16.0f;
        this.y1 = y1 / 16.0f;
        this.z1 = z1 / 16.0f;
        this.x2 = x2 / 16.0f;
        this.y2 = y2 / 16.0f;
        this.z2 = z2 / 16.0f;
        float scaleU = 1.0f / textureWidth;
        float scaleV = 1.0f / textureHeight;
        this.u0 = scaleU * (float)u;
        this.u1 = scaleU * ((float)u + sizeZ);
        this.u2 = scaleU * ((float)u + sizeZ + sizeX);
        this.u3 = scaleU * ((float)u + sizeZ + sizeX + sizeX);
        this.u4 = scaleU * ((float)u + sizeZ + sizeX + sizeZ);
        this.u5 = scaleU * ((float)u + sizeZ + sizeX + sizeZ + sizeX);
        this.v0 = scaleV * (float)v;
        this.v1 = scaleV * ((float)v + sizeZ);
        this.v2 = scaleV * ((float)v + sizeZ + sizeY);
        this.mirror = mirror;
        int cullBitmask = 0;
        for (class_2350 direction : renderDirections) {
            cullBitmask |= 1 << ModelCuboid.getFaceIndex(direction);
        }
        this.cullBitmask = cullBitmask;
    }

    public boolean shouldDrawFace(int faceIndex) {
        return (this.cullBitmask & 1 << faceIndex) != 0;
    }

    public static int getFaceIndex(@NotNull class_2350 dir) {
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> 0;
            case class_2350.field_11036 -> 1;
            case class_2350.field_11043 -> 3;
            case class_2350.field_11035 -> 5;
            case class_2350.field_11039 -> 2;
            case class_2350.field_11034 -> 4;
        };
    }
}

